/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014-2023 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "EspoCRM" word.
 ************************************************************************/

define('views/email/modals/attachments', ['views/modal'], function (Dep) {

    /**
     * @class
     * @name Class
     * @extends module:views/modal.Class
     * @memberOf module:views/email/modals/attachments
     */
    return Dep.extend(/** @lends module:views/email/modals/attachments.Class# */{

        backdrop: true,

        templateContent: `<div class="record">{{{record}}}</div>`,

        setup: function () {
            Dep.prototype.setup.call(this);

            this.headerText = this.translate('attachments', 'fields', 'Email');

            this.createView('record', 'views/record/detail', {
                model: this.model,
                selector: '.record',
                readOnly: true,
                sideView: null,
                buttonsDisabled: true,
                detailLayout: [
                    {
                        rows: [
                            [
                                {
                                    name: 'attachments',
                                    noLabel: true,
                                },
                                false,
                            ]
                        ]
                    }
                ],
            });

            if (!this.model.has('attachmentsIds')) {
                this.wait(
                    this.model.fetch()
                );
            }
        },
    });
});
